import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.response.BindingDetail;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.TModelBag;
import org.uddi4j.util.TModelKey;
import java.util.Vector;

public class UDDIFindBinding1 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		Vector tbv = new Vector();
		TModelKey tk = new TModelKey("UUID:64C756D1-3374-4E00-AE83-EE12E38FAE63");
		tbv.addElement(tk);
		TModelBag tb = new TModelBag();
		tb.setTModelKeyVector(tbv);

		Vector fqv = new Vector();
		FindQualifier fq = new FindQualifier(FindQualifier.sortByDateDesc);
		fqv.addElement(fq);
		FindQualifiers fqs = new FindQualifiers();
		fqs.setFindQualifierVector(fqv);

		BindingDetail bd = proxy.find_binding(fqs, "892d41b0-3aaf-11d5-80dc-002035229c64", tb, 0);

		Vector bdv = bd.getBindingTemplateVector();
		if (bdv.size() == 0) {
			System.out.println("no binding(s) found");
			System.exit(0);
		}

		System.out.println(bdv.size()+" binding(s) found\n");
		for (int i = 0; i < bdv.size(); i++) {
			BindingTemplate bt = (BindingTemplate)bdv.elementAt(i);
			System.out.println(bt.getDefaultDescriptionString());
			System.out.println(bt.getBindingKey());
			System.out.println("\n");
		}
	}
}